/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import jzebra.LogIt;
import jzebra.PrintApplet;
import jzebra.exception.NullCommandException;
import jzebra.exception.NullPrintServiceException;

public class PrintRaw {
    private static final String ERR = "jzebra.PrintRaw.print() failed.";
    private final AtomicReference<DocFlavor> docFlavor = new AtomicReference<DocFlavor.BYTE_ARRAY>(DocFlavor.BYTE_ARRAY.AUTOSENSE);
    private final AtomicReference<DocAttributeSet> docAttr = new AtomicReference<Object>(null);
    private final AtomicReference<PrintRequestAttributeSet> reqAttr = new AtomicReference<HashPrintRequestAttributeSet>(new HashPrintRequestAttributeSet());
    private final AtomicReference<PrintService> ps = new AtomicReference<Object>(null);
    private final AtomicReference<String> rawCmds = new AtomicReference<Object>(null);
    private final AtomicBoolean isFinished = new AtomicBoolean(false);
    private final AtomicReference<Charset> charset = new AtomicReference<Charset>(Charset.defaultCharset());
    private final AtomicReference<String> jobName = new AtomicReference<String>("jZebra Raw Printing");
    private final AtomicReference<String> outputPath = new AtomicReference<Object>(null);
    private final AtomicBoolean alternatePrint = new AtomicBoolean(false);

    public PrintRaw() {
    }

    public PrintRaw(PrintService ps, String rawCmds) {
        this.ps.set(ps);
        this.rawCmds.set(rawCmds);
    }

    public PrintRaw(PrintService ps, String rawCmds, DocFlavor docFlavor, DocAttributeSet docAttr, PrintRequestAttributeSet reqAttr, Charset charset) {
        this.ps.set(ps);
        this.rawCmds.set(rawCmds);
        this.docFlavor.set(docFlavor);
        this.docAttr.set(docAttr);
        this.reqAttr.set(reqAttr);
        this.charset.set(charset);
    }

    public PrintRaw(PrintService ps, String rawCmds, Charset charset, boolean alternatePrint) {
        this.ps.set(ps);
        this.rawCmds.set(rawCmds);
        this.charset.set(charset);
        this.alternatePrint.set(alternatePrint);
    }

    public void setOutputPath(String outputPath) {
        this.outputPath.set(outputPath);
    }

    public boolean print(String rawCmds) throws PrintException, InterruptedException, UnsupportedEncodingException {
        this.set(rawCmds);
        return this.print();
    }

    public boolean printToFile() throws PrintException {
        LogIt.log("Printing to file: " + this.outputPath.get());
        try {
            FileOutputStream out = new FileOutputStream(this.outputPath.get());
            ((OutputStream)out).write(this.rawCmds.get().getBytes(this.charset.get().name()));
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new PrintException("jzebra.PrintRaw.print() failed.: " + e.getLocalizedMessage());
        }
        return true;
    }

    public boolean print() throws PrintException, InterruptedException, UnsupportedEncodingException {
        if (this.ps.get() == null) {
            throw new NullPrintServiceException(ERR);
        }
        if (this.rawCmds.get() == null) {
            throw new NullCommandException(ERR);
        }
        if (this.outputPath.get() != null) {
            return this.printToFile();
        }
        if (this.alternatePrint.get()) {
            return this.alternatePrint();
        }
        SimpleDoc doc = new SimpleDoc(this.rawCmds.get().getBytes(this.charset.get().name()), this.docFlavor.get(), this.docAttr.get());
        this.reqAttr.get().add(new JobName(this.jobName.get(), Locale.getDefault()));
        DocPrintJob pj = this.ps.get().createPrintJob();
        pj.addPrintJobListener(new PrintJobListener(){

            public void printDataTransferCompleted(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobCompleted(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobFailed(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobCanceled(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobNoMoreEvents(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobRequiresAttention(PrintJobEvent pje) {
                LogIt.log(pje);
            }
        });
        LogIt.log("Sending print job to printer: \"" + this.ps.get().getName() + "\"");
        pj.print(doc, this.reqAttr.get());
        while (!this.isFinished.get()) {
            Thread.sleep(100L);
        }
        LogIt.log("Print job received by printer: \"" + this.ps.get().getName() + "\"");
        return true;
    }

    public boolean alternatePrint() throws PrintException {
        File tmpFile = new File("/tmp/jzebra-spool-" + System.currentTimeMillis());
        try {
            this.outputPath.set(tmpFile.getAbsolutePath());
            if (this.printToFile()) {
                String shellCmd = "/usr/bin/lp -d \"" + this.ps.get().getName() + "\" -o raw \"" + tmpFile.getAbsolutePath() + "\";";
                LogIt.log("Runtime Exec running: " + shellCmd);
                Process pr = Runtime.getRuntime().exec(new String[]{"bash", "-c", shellCmd});
                pr.waitFor();
                this.processStream(pr);
            }
        }
        catch (Throwable t) {
            throw new PrintException(t.getLocalizedMessage());
        }
        finally {
            tmpFile.delete();
            this.outputPath.set(null);
        }
        return true;
    }

    private void processStream(Process pr) throws Throwable {
        String tmp;
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        String output = "";
        while ((tmp = buf.readLine()) != null) {
            if (output.length() == 0) {
                output = tmp;
                continue;
            }
            output = output.concat("\n" + tmp);
        }
        LogIt.log("Runtime Exec returned: " + output);
        if (pr.exitValue() != 0) {
            throw new PrintException("Alternate printing returned a non-zero value (" + pr.exitValue() + "). " + output);
        }
    }

    public static boolean print(PrintService ps, String rawCmds) throws PrintException, InterruptedException, UnsupportedEncodingException {
        PrintRaw p = new PrintRaw(ps, rawCmds);
        return p.print();
    }

    public DocAttributeSet getDocAttributeSet() {
        return this.docAttr.get();
    }

    public void setDocAttributeSet(DocAttributeSet docAttr) {
        this.docAttr.set(docAttr);
    }

    public DocFlavor getDocFlavor() {
        return this.docFlavor.get();
    }

    public void setDocFlavor(DocFlavor docFlavor) {
        this.docFlavor.set(docFlavor);
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.reqAttr.get();
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet reqAttr) {
        this.reqAttr.set(reqAttr);
    }

    public PrintService getPrintService() {
        return this.ps.get();
    }

    public void setPrintService(PrintService ps) {
        this.ps.set(ps);
    }

    public void set(String s) {
        this.rawCmds.set(s);
    }

    public String get() {
        return this.rawCmds.get();
    }

    public void clear() {
        try {
            this.rawCmds.set(new String("".getBytes(this.charset.get().name())));
        }
        catch (UnsupportedEncodingException e) {
            this.rawCmds.set("");
        }
    }

    public void append(String s) {
        this.rawCmds.set(this.rawCmds.get().concat(s));
    }

    public void append(byte[] b) throws UnsupportedEncodingException {
        this.append(new String(b, this.charset.get().name()));
    }

    public void setCharset(Charset charset) {
        this.charset.set(charset);
        LogIt.log("Current printer charset encoding: " + charset.name());
    }

    public Charset getCharset() {
        return this.charset.get();
    }

    public boolean isClear() {
        try {
            return this.rawCmds.get().getBytes(this.charset.get().name()).length == 0;
        }
        catch (UnsupportedEncodingException e) {
            return this.rawCmds.get().length() == 0;
        }
    }

    public void setJobName(String jobName) {
        this.jobName.set(jobName);
    }

    public void setAlternatePrinting(boolean alternatePrint) {
        this.alternatePrint.set(alternatePrint);
    }

    public String getJobName() {
        return this.jobName.get();
    }

    public void setPrintParameters(PrintApplet rpa) {
        this.setPrintService(rpa.getPrintService());
        this.setJobName(rpa.getJobName().replace(" ___ ", " Raw "));
        this.setCharset(rpa.getCharset());
        this.setAlternatePrinting(rpa.isAlternatePrinting());
        this.clear();
    }
}

