/*
 * Decompiled with CFR 0.152.
 */
package qz.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import qz.reflection.ReflectException;

public class Reflect {
    private final Object object;
    private final boolean isClass;

    public static Reflect on(String name) throws ReflectException {
        return Reflect.on(Reflect.forName(name));
    }

    public static Reflect on(Class<?> clazz) {
        return new Reflect(clazz);
    }

    public static Reflect on(Object object) {
        return new Reflect(object);
    }

    public static <T extends AccessibleObject> T accessible(T accessible) {
        if (accessible == null) {
            return null;
        }
        if (!accessible.isAccessible()) {
            accessible.setAccessible(true);
        }
        return accessible;
    }

    private Reflect(Class<?> type) {
        this.object = type;
        this.isClass = true;
    }

    private Reflect(Object object) {
        this.object = object;
        this.isClass = false;
    }

    public <T> T get() {
        return (T)this.object;
    }

    public Reflect set(String name, Object value) throws ReflectException {
        try {
            Field field = this.type().getField(name);
            field.set(this.object, Reflect.unwrap(value));
            return this;
        }
        catch (Exception e1) {
            try {
                Reflect.accessible(this.type().getDeclaredField(name)).set(this.object, Reflect.unwrap(value));
                return this;
            }
            catch (Exception e2) {
                throw new ReflectException(e2);
            }
        }
    }

    public <T> T get(String name) throws ReflectException {
        return this.field(name).get();
    }

    public Reflect field(String name) throws ReflectException {
        try {
            Field field = this.type().getField(name);
            return Reflect.on(field.get(this.object));
        }
        catch (Exception e1) {
            try {
                return Reflect.on(Reflect.accessible(this.type().getDeclaredField(name)).get(this.object));
            }
            catch (Exception e2) {
                throw new ReflectException(e2);
            }
        }
    }

    public Map<String, Reflect> fields() {
        LinkedHashMap<String, Reflect> result = new LinkedHashMap<String, Reflect>();
        Field[] fieldArray = this.type().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field;
            if (!this.isClass ^ Modifier.isStatic((field = fieldArray[n2]).getModifiers())) {
                String name = field.getName();
                result.put(name, this.field(name));
            }
            ++n2;
        }
        return result;
    }

    public Reflect call(String name) throws ReflectException {
        return this.call(name, new Object[0]);
    }

    /*
     * Unable to fully structure code
     */
    public Reflect call(String name, Object ... args) throws ReflectException {
        types = Reflect.types(args);
        try {
            method = this.type().getMethod(name, types);
            return Reflect.on(method, this.object, args);
        }
        catch (NoSuchMethodException e) {
            var8_6 = this.type().getMethods();
            var7_7 = var8_6.length;
            var6_8 = 0;
            ** while (var6_8 < var7_7)
        }
lbl-1000:
        // 1 sources

        {
            method = var8_6[var6_8];
            if (method.getName().equals(name) && this.match(method.getParameterTypes(), types)) {
                return Reflect.on(method, this.object, args);
            }
            ++var6_8;
            continue;
        }
lbl15:
        // 1 sources

        throw new ReflectException(e);
    }

    public Reflect create() throws ReflectException {
        return this.create(new Object[0]);
    }

    /*
     * Unable to fully structure code
     */
    public Reflect create(Object ... args) throws ReflectException {
        types = Reflect.types(args);
        try {
            constructor = this.type().getConstructor(types);
            return Reflect.on(constructor, args);
        }
        catch (NoSuchMethodException e) {
            var7_5 = this.type().getConstructors();
            var6_6 = var7_5.length;
            var5_7 = 0;
            ** while (var5_7 < var6_6)
        }
lbl-1000:
        // 1 sources

        {
            constructor = var7_5[var5_7];
            if (this.match(constructor.getParameterTypes(), types)) {
                return Reflect.on(constructor, args);
            }
            ++var5_7;
            continue;
        }
lbl15:
        // 1 sources

        throw new ReflectException(e);
    }

    public <P> P as(Class<P> proxyType) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return Reflect.on(Reflect.this.object).call(method.getName(), args).get();
            }
        };
        return (P)Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, handler);
    }

    private boolean match(Class<?>[] declaredTypes, Class<?>[] actualTypes) {
        if (declaredTypes.length == actualTypes.length) {
            int i = 0;
            while (i < actualTypes.length) {
                if (!Reflect.wrapper(declaredTypes[i]).isAssignableFrom(Reflect.wrapper(actualTypes[i]))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Reflect) {
            return this.object.equals(((Reflect)obj).get());
        }
        return false;
    }

    public String toString() {
        return this.object.toString();
    }

    private static Reflect on(Constructor<?> constructor, Object ... args) throws ReflectException {
        try {
            return Reflect.on(constructor.newInstance(args));
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    private static Reflect on(Method method, Object object, Object ... args) throws ReflectException {
        try {
            Reflect.accessible(method);
            if (method.getReturnType() == Void.TYPE) {
                method.invoke(object, args);
                return Reflect.on(object);
            }
            return Reflect.on(method.invoke(object, args));
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    private static Object unwrap(Object object) {
        if (object instanceof Reflect) {
            return ((Reflect)object).get();
        }
        return object;
    }

    private static Class<?>[] types(Object ... values) {
        if (values == null) {
            return new Class[0];
        }
        Class[] result = new Class[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = values[i].getClass();
            ++i;
        }
        return result;
    }

    private static Class<?> forName(String name) throws ReflectException {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    public Class<?> type() {
        if (this.isClass) {
            return (Class)this.object;
        }
        return this.object.getClass();
    }

    private static Class<?> wrapper(Class<?> type) {
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        return type;
    }
}

