/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.applet.Applet;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import javax.print.PrintException;
import javax.print.PrintService;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import qz.BrowserTools;
import qz.ByteArrayBuilder;
import qz.ByteUtilities;
import qz.LogIt;
import qz.Printer;
import qz.SerialPortFinder;
import qz.SerialUtilities;

public class SerialPrinter
implements Printer {
    private int baudRate = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int flowControl = 0;
    private int parity = 0;
    private boolean serialPortsFound = false;
    private byte[] begin = new byte[]{2};
    private byte[] end = new byte[]{13};
    private int timeout;
    private ByteArrayBuilder outputBuffer;
    private ByteArrayBuilder inputBuffer;
    private byte[] output;
    private SerialPort port = null;
    private String serialPorts;
    private String[] portArray;
    private String portName;
    private final Applet applet;
    private final BrowserTools btools;
    private final boolean ready;

    public SerialPrinter(Applet applet) {
        this.applet = applet;
        this.btools = new BrowserTools(applet);
        this.ready = true;
        this.setTimeout(1200);
    }

    @Override
    public String getName() {
        return "Serial Printer";
    }

    @Override
    public void printRaw(ByteArrayBuilder data) throws PrintException {
        LogIt.log(Level.WARNING, "Serial Printer does not support raw printing.");
    }

    @Override
    public void printAlternate(ByteArrayBuilder data) throws PrintException {
        LogIt.log(Level.WARNING, "Serial Printer does not support alternate printing.");
    }

    @Override
    public boolean ready() {
        return this.ready;
    }

    @Override
    public void setPrintService(PrintService ps) {
        LogIt.log(Level.WARNING, "Serial Printer does not require a print service.");
    }

    @Override
    public PrintService getPrintService() {
        LogIt.log(Level.WARNING, "Serial Printer does not require a print service.");
        return null;
    }

    @Override
    public String getType() {
        return "Serial";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setJobTitle(String jobTitle) {
    }

    public void findPorts() {
        SerialPortFinder finder = new SerialPortFinder(this);
        Thread finderThread = new Thread(finder);
        finderThread.start();
    }

    public String getPorts() {
        return this.serialPorts;
    }

    public boolean openPort(String portName) {
        if (!this.serialPortsFound) {
            this.findPorts();
        }
        if (this.port == null) {
            this.portName = portName;
            this.port = new SerialPort(this.portName);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        SerialPrinter.this.port.openPort();
                    }
                    catch (SerialPortException ex) {
                        SerialPrinter.this.port = null;
                        LogIt.log(Level.SEVERE, "Could not open serial port.", ex);
                    }
                    return null;
                }
            });
            try {
                this.port.addEventListener(new SerialPortEventListener(){

                    public void serialEvent(SerialPortEvent spe) {
                        SerialPrinter.this.serialEventListener(spe);
                    }
                });
            }
            catch (SerialPortException ex) {
                LogIt.log(Level.SEVERE, "Could not add listener to serial port.", ex);
            }
            this.portName = portName;
            LogIt.log("Opened Serial Port " + this.portName);
        } else {
            LogIt.log(Level.WARNING, "Serial Port [" + this.portName + "] already appears to be open.");
        }
        this.btools.notifyBrowser("qzDoneOpeningPort", portName);
        return this.port.isOpened();
    }

    public boolean closePort(String portName) {
        return this.closePort(portName, true);
    }

    public boolean closePort(String portName, boolean warnClosed) {
        if (this.port == null || !this.port.isOpened()) {
            if (warnClosed) {
                LogIt.log(Level.WARNING, "Serial Port [" + portName + "] does not appear to be open.");
            }
            return false;
        }
        boolean closed = false;
        try {
            closed = this.port.closePort();
        }
        catch (SerialPortException ex) {
            LogIt.log(Level.SEVERE, "Could not close serial port.", ex);
        }
        if (!closed) {
            LogIt.log(Level.WARNING, "Serial Port [" + portName + "] was not closed properly.");
        } else {
            LogIt.log("Port [" + portName + "] closed successfully.");
        }
        this.btools.notifyBrowser("qzDoneClosingPort", portName);
        this.port = null;
        this.portName = null;
        return closed;
    }

    public void setSerialBegin(ByteArrayBuilder serialBegin) {
        this.begin = serialBegin.getByteArray();
    }

    public void setSerialEnd(ByteArrayBuilder serialEnd) {
        this.end = serialEnd.getByteArray();
    }

    public void setSerialProperties(String baud, String dataBits, String stopBits, String parity, String flowControl) {
        this.baudRate = SerialUtilities.parseBaudRate(baud);
        this.dataBits = SerialUtilities.parseDataBits(dataBits);
        this.stopBits = SerialUtilities.parseStopBits(stopBits);
        this.parity = SerialUtilities.parseParity(parity);
        this.flowControl = SerialUtilities.parseFlowControl(flowControl);
    }

    public void send(String serialData) {
        if (this.port != null) {
            this.inputBuffer = this.getInputBuffer();
            this.inputBuffer.append(serialData.getBytes());
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        SerialPrinter.this.port.setParams(SerialPrinter.this.baudRate, SerialPrinter.this.dataBits, SerialPrinter.this.stopBits, SerialPrinter.this.parity);
                        SerialPrinter.this.port.setFlowControlMode(SerialPrinter.this.flowControl);
                        LogIt.log("Sending data to [" + SerialPrinter.this.portName + "]:\r\n\r\n" + new String(SerialPrinter.this.getInputBuffer().getByteArray()) + "\r\n\r\n");
                        SerialPrinter.this.port.writeBytes(SerialPrinter.this.getInputBuffer().getByteArray());
                        SerialPrinter.this.getInputBuffer().clear();
                    }
                    catch (SerialPortException ex) {
                        LogIt.log(Level.SEVERE, "Could not send data to serial port.", ex);
                    }
                    return null;
                }
            });
        } else {
            LogIt.log(Level.SEVERE, "No serial port is open.");
        }
    }

    public String getReturnData() {
        if (this.output != null) {
            String returnData = new String(this.output);
            this.output = null;
            return returnData;
        }
        return null;
    }

    private void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void doneFindingPorts(String serialPorts, Boolean serialPortsFound) {
        this.serialPorts = serialPorts;
        this.serialPortsFound = serialPortsFound;
        this.btools.notifyBrowser("qzDoneFindingPorts");
    }

    public void serialEventListener(SerialPortEvent event) {
        try {
            if (event.isRXCHAR()) {
                this.getOutputBuffer().append(this.port.readBytes(event.getEventValue(), this.timeout));
                int[] beginPos = ByteUtilities.indicesOfSublist(this.getOutputBuffer().getByteArray(), this.begin);
                int[] endPos = ByteUtilities.indicesOfSublist(this.getOutputBuffer().getByteArray(), this.end);
                if (beginPos.length > 0 && endPos.length > 0) {
                    int _begin = beginPos[beginPos.length - 1];
                    int _end = endPos[endPos.length - 1];
                    this.output = new byte[_end - _begin];
                    System.arraycopy(this.getOutputBuffer().getByteArray(), _begin, this.output, 0, _end - _begin);
                    this.getOutputBuffer().clear();
                }
                if (this.output != null) {
                    LogIt.log("Received Serial Data: " + new String(this.output));
                    this.btools.notifyBrowser("qzSerialReturned", new String(this.output));
                } else {
                    LogIt.log(Level.WARNING, "Received serial data but it was null. Please check the begin and end characters.");
                }
            }
        }
        catch (SerialPortException e) {
            LogIt.log(Level.SEVERE, "Exception occured while reading data from port.", e);
        }
        catch (SerialPortTimeoutException e) {
            LogIt.log(Level.WARNING, "Timeout occured waiting for port to respond.  Timeout value: " + this.timeout, e);
        }
    }

    public ByteArrayBuilder getInputBuffer() {
        if (this.inputBuffer == null) {
            this.inputBuffer = new ByteArrayBuilder();
        }
        return this.inputBuffer;
    }

    private ByteArrayBuilder getOutputBuffer() {
        if (this.outputBuffer == null) {
            this.outputBuffer = new ByteArrayBuilder();
        }
        return this.outputBuffer;
    }
}

