/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import jssc.SerialPortList;
import qz.LogIt;
import qz.SerialPrinter;

public class SerialPortFinder
implements Runnable {
    SerialPrinter printer;

    SerialPortFinder(SerialPrinter printer) {
        this.printer = printer;
    }

    @Override
    public void run() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String serialPorts = "";
                Boolean serialPortsFound = false;
                try {
                    StringBuilder sb = new StringBuilder();
                    String[] portArray = SerialPortList.getPortNames();
                    int i = 0;
                    while (i < portArray.length) {
                        sb.append(portArray[i]).append(i < portArray.length - 1 ? "," : "");
                        ++i;
                    }
                    serialPorts = sb.toString();
                    serialPortsFound = true;
                    LogIt.log("Found Serial Ports: " + serialPorts);
                }
                catch (NullPointerException ex) {
                    LogIt.log(Level.SEVERE, "Null pointer.", ex);
                }
                catch (NoClassDefFoundError ex) {
                    LogIt.log(Level.SEVERE, "Problem communicating with the JSSC class.", ex);
                }
                SerialPortFinder.this.printer.doneFindingPorts(serialPorts, serialPortsFound);
                return null;
            }
        });
    }
}

