/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Locale;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import qz.ByteArrayBuilder;
import qz.FilePrinter;
import qz.LogIt;
import qz.Printer;

public class RawPrinter
implements Printer {
    private String name;
    private PrintService ps;
    private boolean isFinished;
    private final DocFlavor docFlavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
    private DocAttributeSet docAttr;
    private final PrintRequestAttributeSet reqAttr = new HashPrintRequestAttributeSet();
    private String jobTitle;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void printRaw(ByteArrayBuilder data) throws PrintException {
        block5: {
            SimpleDoc doc = new SimpleDoc(data.getByteArray(), this.docFlavor, this.docAttr);
            this.reqAttr.add(new JobName(this.jobTitle, Locale.getDefault()));
            DocPrintJob pj = this.ps.createPrintJob();
            pj.addPrintJobListener(new PrintJobListener(){

                @Override
                public void printDataTransferCompleted(PrintJobEvent pje) {
                    LogIt.log(pje);
                    RawPrinter.this.isFinished = true;
                }

                @Override
                public void printJobCompleted(PrintJobEvent pje) {
                    LogIt.log(pje);
                    RawPrinter.this.isFinished = true;
                }

                @Override
                public void printJobFailed(PrintJobEvent pje) {
                    LogIt.log(pje);
                    RawPrinter.this.isFinished = true;
                }

                @Override
                public void printJobCanceled(PrintJobEvent pje) {
                    LogIt.log(pje);
                    RawPrinter.this.isFinished = true;
                }

                @Override
                public void printJobNoMoreEvents(PrintJobEvent pje) {
                    LogIt.log(pje);
                    RawPrinter.this.isFinished = true;
                }

                @Override
                public void printJobRequiresAttention(PrintJobEvent pje) {
                    LogIt.log(pje);
                }
            });
            LogIt.log("Sending print job to printer: \"" + this.ps.getName() + "\"");
            try {
                pj.print(doc, this.reqAttr);
            }
            catch (PrintException ex) {
                LogIt.log(Level.SEVERE, "Raw print error.", ex);
                if (!ex.getLocalizedMessage().toLowerCase().contains("/usr/bin/lpr") && !ex.getLocalizedMessage().toLowerCase().contains("operation not permitted")) break block5;
                LogIt.log(Level.INFO, "Browser security seems to be blocking the print operation.  Please trust this applet via browser settings.");
            }
        }
        while (!this.isFinished) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LogIt.log(Level.SEVERE, "Raw print process interrupted.", ex);
            }
        }
        LogIt.log("Print job received by printer: \"" + this.ps.getName() + "\"");
    }

    @Override
    public void printAlternate(ByteArrayBuilder data) throws PrintException {
        File tmpFile = new File("/tmp/qz-spool-" + System.currentTimeMillis());
        FilePrinter filePrinter = new FilePrinter();
        try {
            try {
                filePrinter.setOutputPath(tmpFile.getAbsolutePath());
                filePrinter.printRaw(data);
                String shellCmd = "/usr/bin/lp -d \"" + this.ps.getName() + "\" -o raw \"" + tmpFile.getAbsolutePath() + "\";";
                LogIt.log("Runtime Exec running: " + shellCmd);
                Process pr = Runtime.getRuntime().exec(new String[]{"bash", "-c", shellCmd});
                pr.waitFor();
                this.processStream(pr);
            }
            catch (Throwable t) {
                throw new PrintException(t.getLocalizedMessage());
            }
        }
        finally {
            tmpFile.delete();
        }
    }

    public void printToHost(ByteArrayBuilder data, String jobHost, int jobPort) {
        LogIt.log("Printing to host " + jobHost + ":" + jobPort);
        try {
            Socket socket = new Socket(jobHost, jobPort);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.write(data.getByteArray());
            socket.close();
        }
        catch (IOException ex) {
            LogIt.log(Level.SEVERE, "Could not print to host.", ex);
        }
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void setPrintService(PrintService ps) {
        this.ps = ps;
    }

    @Override
    public PrintService getPrintService() {
        return this.ps;
    }

    @Override
    public String getType() {
        return "RAW";
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public void processStream(Process pr) throws Throwable {
        String tmp;
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        String output = "";
        while ((tmp = buf.readLine()) != null) {
            output = output.length() == 0 ? tmp : output.concat("\n" + tmp);
        }
        LogIt.log("Runtime Exec returned: " + output);
        if (pr.exitValue() != 0) {
            throw new PrintException("Alternate printing returned a non-zero value (" + pr.exitValue() + "). " + output);
        }
    }
}

