/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.JEditorPane;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageable;
import qz.ByteArrayBuilder;
import qz.LanguageType;
import qz.LogIt;
import qz.PrintJob;
import qz.PrintJobElementPreparer;
import qz.PrintJobElementType;
import qz.exception.InvalidRawImageException;
import qz.exception.NullCommandException;

public class PrintJobElement {
    private final PrintJobElementType type;
    private final PrintJob pj;
    private final ByteArrayBuilder data;
    private int sequence;
    private boolean prepared;
    private ByteArrayBuilder preparedData;
    private final Charset charset;
    private int imageX = 0;
    private int imageY = 0;
    private int dotDensity = 32;
    private LanguageType lang;
    private String xmlTag;
    private BufferedImage bufferedImage;
    private PDDocument pdfFile;
    private PDPageable pdfPages;
    private String pdfFileName;
    private JEditorPane rtfEditor;

    PrintJobElement(PrintJob pj, ByteArrayBuilder data, PrintJobElementType type, Charset charset, String lang, int dotDensity) {
        this.lang = LanguageType.getType(lang);
        this.dotDensity = dotDensity;
        this.pj = pj;
        this.data = data;
        this.type = type;
        this.charset = charset;
        this.prepared = false;
    }

    PrintJobElement(PrintJob pj, ByteArrayBuilder data, PrintJobElementType type, Charset charset, String lang, int imageX, int imageY) {
        this.lang = LanguageType.getType(lang);
        this.imageX = imageX;
        this.imageY = imageY;
        this.pj = pj;
        this.data = data;
        this.type = type;
        this.charset = charset;
        this.prepared = false;
    }

    PrintJobElement(PrintJob pj, ByteArrayBuilder data, PrintJobElementType type, Charset charset, String xmlTag) {
        this.xmlTag = xmlTag;
        this.pj = pj;
        this.data = data;
        this.type = type;
        this.charset = charset;
        this.prepared = false;
    }

    PrintJobElement(PrintJob pj, ByteArrayBuilder data, PrintJobElementType type, Charset charset) {
        this.pj = pj;
        this.data = data;
        this.type = type;
        this.charset = charset;
        this.prepared = false;
    }

    public void prepare() throws IOException, InvalidRawImageException, NullCommandException {
        PrintJobElementPreparer preparer = new PrintJobElementPreparer(this.type, this.data, this.charset, this);
        Thread preparerThread = new Thread(preparer);
        preparerThread.start();
    }

    public void donePreparing(ByteArrayBuilder preparedData, BufferedImage bufferedImage, JEditorPane rtfEditor, PDDocument pdfFile) {
        this.prepared = true;
        this.preparedData = preparedData;
        this.bufferedImage = bufferedImage;
        this.rtfEditor = rtfEditor;
        this.pdfFile = pdfFile;
        LogIt.log("Done preparing PrintJobElement.");
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public ByteArrayBuilder getData() {
        return this.preparedData;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public PrintJobElementType getType() {
        return this.type;
    }

    public PDDocument getPDFFile() {
        return this.pdfFile;
    }

    public JEditorPane getRtfData() {
        return this.rtfEditor;
    }

    public int getRtfHeight() {
        return this.rtfEditor.getHeight();
    }

    public int getRtfWidth() {
        return this.rtfEditor.getWidth();
    }

    public LanguageType getLang() {
        return this.lang;
    }

    public int getDotDensity() {
        return this.dotDensity;
    }

    public int getImageX() {
        return this.imageX;
    }

    public int getImageY() {
        return this.imageY;
    }

    public String getXmlTag() {
        return this.xmlTag;
    }
}

