/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.print.PrintException;
import javax.print.PrintService;
import qz.ByteArrayBuilder;
import qz.FileUtilities;
import qz.LogIt;
import qz.Printer;
import qz.exception.InvalidFileTypeException;

public class FilePrinter
implements Printer {
    private String name = "File Printer";
    private String outputPath;
    private String jobTitle;

    FilePrinter() {
    }

    public void setOutputPath(String outputPath) throws InvalidFileTypeException {
        if (FileUtilities.isBadExtension(outputPath)) {
            throw new InvalidFileTypeException("Writing file \"" + outputPath + "\" is prohibited for security reason: " + "Prohibited file extension.");
        }
        this.outputPath = outputPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public PrintService getPrintService() {
        return null;
    }

    @Override
    public String getType() {
        return "FILE";
    }

    @Override
    public void printRaw(ByteArrayBuilder data) throws PrintException {
        LogIt.log("Printing to file: " + this.outputPath);
        try {
            FileOutputStream fos = new FileOutputStream(this.outputPath);
            fos.write(data.getByteArray());
            fos.close();
        }
        catch (FileNotFoundException ex) {
            LogIt.log(ex);
        }
        catch (IOException ex) {
            LogIt.log(ex);
        }
    }

    @Override
    public void printAlternate(ByteArrayBuilder data) throws PrintException {
        LogIt.log(Level.WARNING, "Cannot use alternate printing on a File printer.");
    }

    @Override
    public void setPrintService(PrintService ps) {
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }
}

