/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.util.LinkedList;
import java.util.logging.Level;
import qz.ByteArrayBuilder;
import qz.LogIt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteUtilities {
    private static final String HEXES = "0123456789ABCDEF";

    public static byte[] hexStringToByteArray(String s) throws NumberFormatException {
        byte[] data = new byte[]{};
        if (s != null && s.length() > 0) {
            if (s.length() > 2) {
                String[] split;
                if (s.length() >= 3 && s.contains("x")) {
                    s = s.startsWith("x") ? s.substring(1) : s;
                    s = s.endsWith("x") ? s.substring(0, s.length() - 1) : s;
                    split = s.split("x");
                } else {
                    split = s.split("(?<=\\G..)");
                }
                data = new byte[split.length];
                for (int i = 0; i < split.length; ++i) {
                    data[i] = Byte.parseByte(split[i], 16);
                }
            } else if (s.length() == 2) {
                data = new byte[]{Byte.parseByte(s)};
            }
        }
        return data;
    }

    public static int[] indicesOfSublist(byte[] array, byte[] sublist) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        if (array == null || sublist == null || array.length == 0 || sublist.length == 0 || sublist.length > array.length) {
            return new int[0];
        }
        block0: for (int i = 0; i < array.length - sublist.length + 1; ++i) {
            for (int j = 0; j < sublist.length; ++j) {
                if (array[i + j] != sublist[j]) continue block0;
            }
            indexes.add(i);
        }
        int[] int_array = new int[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            int_array[i] = (Integer)indexes.get(i);
        }
        return int_array;
    }

    public static LinkedList<ByteArrayBuilder> splitByteArray(byte[] src, byte[] pattern, int count) throws NullPointerException, IndexOutOfBoundsException, ArrayStoreException {
        LinkedList<ByteArrayBuilder> byteArrayList = new LinkedList<ByteArrayBuilder>();
        int[] split = ByteUtilities.indicesOfSublist(src, pattern);
        count = count < 1 ? 1 : count;
        int _count = 1;
        int prev = 0;
        ByteArrayBuilder b = new ByteArrayBuilder();
        for (int i : split) {
            byte[] temp = new byte[i - prev + pattern.length];
            System.arraycopy(src, prev, temp, 0, temp.length);
            b.append(temp);
            if (_count < count) {
                ++_count;
            } else {
                byteArrayList.add(b);
                b = new ByteArrayBuilder();
                _count = 1;
            }
            prev = i + pattern.length;
        }
        if (!byteArrayList.contains(b)) {
            byteArrayList.add(b);
        }
        return byteArrayList;
    }

    public static byte[] intArrayToByteArray(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    public static int[] binaryArrayToIntArray(boolean[] black) {
        int[] hex = new int[black.length / 8];
        for (int i = 0; i < hex.length; ++i) {
            for (int k = 0; k < 8; ++k) {
                int n = i;
                hex[n] = hex[n] + ((black[8 * i + k] ? 1 : 0) << 7 - k);
            }
        }
        return hex;
    }

    public static String getHexString(int[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (int i : raw) {
            hex.append(HEXES.charAt((i & 0xF0) >> 4)).append(HEXES.charAt(i & 0xF));
        }
        return hex.toString();
    }

    public static boolean isBlank(Object o) {
        if (o instanceof byte[]) {
            return ((byte[])o).length < 1;
        }
        if (o instanceof String) {
            return (String)o == null || ((String)o).equals("");
        }
        LogIt.log(Level.WARNING, "Uchecked blank comparison.");
        return o == null;
    }
}

