/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.applet.Applet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import qz.BrowserTools;
import qz.ByteArrayBuilder;
import qz.FilePrinter;
import qz.FileUtilities;
import qz.LogIt;
import qz.NetworkUtilities;
import qz.PaperFormat;
import qz.PrintJob;
import qz.PrintJobState;
import qz.Printer;
import qz.RawPrinter;
import qz.SerialPrinter;
import qz.exception.InvalidFileTypeException;
import qz.exception.NullCommandException;
import qz.exception.NullPrintServiceException;
import qz.json.JSONArray;
import qz.reflection.ReflectException;

public class PrintSpooler
implements Runnable {
    private boolean running;
    private PrintJob currentJob;
    private Thread currentJobThread;
    private JSONArray queueInfo;
    private final ArrayList<PrintJob> spool = new ArrayList();
    private ListIterator<PrintJob> spoolIterator;
    private Printer currentPrinter;
    private String lastPrinterName;
    private ArrayList<Printer> printerList;
    private FilePrinter filePrinter;
    private SerialPrinter serialPrinter;
    private PaperFormat paperSize;
    private boolean autoSize;
    private boolean logPSFeatures;
    private String endOfDocument;
    private int docsPerSpool;
    private int openJobs;
    private NetworkUtilities networkUtilities;
    private String macAddress;
    private String ipAddress;
    private boolean alternatePrint;
    private Applet applet;
    private Throwable exception;
    private PrintService defaultPS;
    private boolean serialEnabled = false;
    private BrowserTools btools;
    private Boolean defaultPrinterOnly = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.btools = new BrowserTools(this.applet);
        LogIt.log("PrintSpooler started");
        this.running = true;
        this.filePrinter = new FilePrinter();
        this.logPSFeatures = false;
        this.endOfDocument = "";
        this.docsPerSpool = 0;
        this.openJobs = 0;
        this.alternatePrint = false;
        this.exception = null;
        this.currentPrinter = null;
        this.defaultPS = PrintServiceLookup.lookupDefaultPrintService();
        this.printerList = this.findAllPrinters();
        int loopDelay = 100;
        this.btools.notifyBrowser("qzReady");
        while (this.running) {
            ArrayList<PrintJob> arrayList = this.spool;
            synchronized (arrayList) {
                if (this.spool.size() > 0) {
                    this.spoolIterator = this.spool.listIterator();
                    JSONArray currentQueueInfo = new JSONArray();
                    while (this.spoolIterator.hasNext()) {
                        int jobIndex = this.spoolIterator.nextIndex();
                        PrintJob job = this.spoolIterator.next();
                        PrintJobState jobState = job.getJobState();
                        switch (jobState) {
                            case STATE_PROCESSING: {
                                job.isProcessed();
                                break;
                            }
                            case STATE_PROCESSED: {
                                job.queue();
                                break;
                            }
                            case STATE_QUEUED: {
                                if (!job.getPrinter().ready()) break;
                                job.print();
                            }
                        }
                        HashMap<String, String> jobInfo = new HashMap<String, String>();
                        jobInfo.put("id", String.valueOf(jobIndex));
                        jobInfo.put("title", job.getTitle());
                        jobInfo.put("state", jobState.name());
                        jobInfo.put("copies", Integer.toString(job.getCopies()));
                        currentQueueInfo.put(jobInfo);
                    }
                    this.queueInfo = currentQueueInfo;
                }
            }
            try {
                Thread.sleep(loopDelay);
            }
            catch (InterruptedException ex) {
                LogIt.log(Level.SEVERE, "Print spooler interrupted.", ex);
            }
        }
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
        this.serialPrinter = this.getSerialPrinter();
    }

    private SerialPrinter getSerialPrinter() {
        try {
            Class.forName("jssc.SerialPort");
            if (this.serialPrinter == null) {
                this.serialPrinter = new SerialPrinter(this.applet);
                this.serialEnabled = true;
            }
        }
        catch (ClassNotFoundException c) {
            LogIt.log(Level.WARNING, "JSSC library could not be found. Serial functionality has been disabled.");
            this.setException(c);
        }
        return this.serialPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintJob createJob() {
        ++this.openJobs;
        this.currentJob = new PrintJob();
        if (this.paperSize != null) {
            this.currentJob.setPaperSize(this.paperSize);
        }
        if (this.autoSize) {
            this.currentJob.setAutoSize(true);
        }
        this.currentJob.setLogPostScriptFeatures(this.logPSFeatures);
        this.currentJob.setAlternatePrinting(this.alternatePrint);
        ArrayList<PrintJob> arrayList = this.spool;
        synchronized (arrayList) {
            this.spool.add(this.currentJob);
        }
        return this.currentJob;
    }

    public void append(ByteArrayBuilder data, Charset charset) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.append(data, charset);
    }

    public void appendImage(ByteArrayBuilder imagePath, Charset charset, String lang, int imageX, int imageY) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.appendImage(imagePath, charset, lang, imageX, imageY);
    }

    public void appendImage(ByteArrayBuilder imagePath, Charset charset, String lang, int dotDensity) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.appendImage(imagePath, charset, lang, dotDensity);
    }

    public void appendPSImage(ByteArrayBuilder url, Charset charset) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.appendPSImage(url, charset);
    }

    public void appendXML(ByteArrayBuilder url, Charset charset, String xmlTag) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.appendXML(url, charset, xmlTag);
    }

    public void appendFile(ByteArrayBuilder url, Charset charset) {
        if (!"".equals(this.endOfDocument)) {
            String[] consolidatedData;
            String[] fileData = this.getFileData(url, charset).split(this.endOfDocument);
            if (this.docsPerSpool > 1) {
                int dataLength = fileData.length;
                int newArrayLength = (dataLength - dataLength % this.docsPerSpool) / this.docsPerSpool + 1;
                consolidatedData = new String[newArrayLength];
                int i = 0;
                while (i < newArrayLength) {
                    String jobData = "";
                    int j = 0;
                    while (j < this.docsPerSpool) {
                        int index = i * this.docsPerSpool + j;
                        if (index < dataLength) {
                            jobData = String.valueOf(jobData) + fileData[index] + this.endOfDocument;
                        }
                        ++j;
                    }
                    consolidatedData[i] = jobData;
                    ++i;
                }
            } else {
                consolidatedData = new String[fileData.length];
                int i = 0;
                while (i < fileData.length) {
                    consolidatedData[i] = String.valueOf(fileData[i]) + this.endOfDocument;
                    ++i;
                }
            }
            String[] stringArray = consolidatedData;
            int n = consolidatedData.length;
            int n2 = 0;
            while (n2 < n) {
                String dataString = stringArray[n2];
                if (this.currentJob == null) {
                    this.createJob();
                }
                ByteArrayBuilder bytes = new ByteArrayBuilder();
                try {
                    bytes.append(dataString, charset);
                }
                catch (UnsupportedEncodingException ex) {
                    LogIt.log(Level.SEVERE, "Unsupported encoding.", ex);
                }
                this.currentJob.append(bytes, charset);
                this.currentJob = null;
                ++n2;
            }
            this.endOfDocument = "";
            this.docsPerSpool = 0;
        } else {
            if (this.currentJob == null) {
                this.createJob();
            }
            this.currentJob.appendFile(url, charset);
        }
    }

    public void appendRtfFile(ByteArrayBuilder url, Charset charset) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.appendRtfFile(url, charset);
    }

    public void appendHTML(ByteArrayBuilder html, Charset charset) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.appendHTML(html, charset);
    }

    public void appendPDF(ByteArrayBuilder url, Charset charset) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.appendPDF(url, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean print() {
        if (this.currentPrinter == null) {
            LogIt.log("A printer has not been selected.");
            this.setException(new NullPrintServiceException("A printer has not been selected."));
            return false;
        }
        this.lastPrinterName = this.currentPrinter.getName();
        if (this.openJobs == 0) {
            LogIt.log(Level.WARNING, "No data has been provided.");
            this.setException(new NullCommandException("No data has been provided."));
            return false;
        }
        if (this.openJobs == 1) {
            this.currentJob.setPrinter(this.currentPrinter);
            this.currentJob.prepareJob();
            this.currentJob = null;
            this.openJobs = 0;
            return true;
        }
        ArrayList<PrintJob> arrayList = this.spool;
        synchronized (arrayList) {
            while (this.openJobs > 0) {
                PrintJob job = this.spool.get(this.spool.size() - this.openJobs);
                job.setPrinter(this.currentPrinter);
                job.prepareJob();
                --this.openJobs;
            }
        }
        this.currentJob = null;
        return true;
    }

    public void printToFile(String filePath) {
        if (this.currentJob != null) {
            this.lastPrinterName = "File";
            try {
                this.filePrinter.setOutputPath(filePath);
                this.currentJob.setPrinter(this.filePrinter);
                this.currentJob.prepareJob();
            }
            catch (InvalidFileTypeException ex) {
                LogIt.log(Level.SEVERE, "Invalid file type.", ex);
                this.setException(ex);
            }
            this.currentJob = null;
        } else {
            LogIt.log(Level.SEVERE, "No data has been provided.");
            this.setException(new NullCommandException("No data has been provided."));
        }
    }

    public void printToHost(String jobHost, int jobPort) {
        if (this.currentJob != null) {
            this.lastPrinterName = "Remote Host";
            this.currentJob.setHostOutput(jobHost, jobPort);
            this.currentJob.prepareJob();
            this.currentJob = null;
        } else {
            LogIt.log(Level.SEVERE, "No data has been provided.");
            this.setException(new NullCommandException("No data has been provided."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJob(int jobIndex) {
        ArrayList<PrintJob> arrayList = this.spool;
        synchronized (arrayList) {
            PrintJob job = this.spool.get(jobIndex);
            job.cancel();
            this.spool.set(jobIndex, job);
        }
    }

    public JSONArray getQueueInfo() {
        return this.queueInfo;
    }

    public String getJobInfo(int jobIndex) {
        PrintJob job = this.spool.get(jobIndex);
        String jobInfo = job.getInfo();
        LogIt.log("Job Data: " + jobInfo);
        return jobInfo;
    }

    public ArrayList<Printer> findAllPrinters() {
        LogIt.log("Searching for available printers...");
        ArrayList<Printer> printers = new ArrayList<Printer>();
        PrintService[] psList = this.defaultPrinterOnly != false ? new PrintService[]{this.defaultPS} : PrintServiceLookup.lookupPrintServices(null, null);
        PrintService[] printServiceArray = psList;
        int n = psList.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService ps = printServiceArray[n2];
            PrintServiceAttributeSet psa = ps.getAttributes();
            RawPrinter printer = new RawPrinter();
            printer.setPrintService(ps);
            printer.setName(ps.getAttribute(PrinterName.class).getValue());
            printers.add(printer);
            ++n2;
        }
        LogIt.log("Found " + printers.size() + " printers.");
        return printers;
    }

    public String getPrinters() {
        StringBuilder sb = new StringBuilder();
        ListIterator<Printer> iterator = this.getPrinterList().listIterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next().getName());
            sb.append(iterator.hasNext() ? "," : "");
        }
        return sb.toString();
    }

    public ArrayList<Printer> getPrinterList() {
        return this.printerList;
    }

    private Printer getDefaultPrinter() {
        ListIterator<Printer> iterator = this.printerList.listIterator();
        while (iterator.hasNext()) {
            Printer printer = iterator.next();
            if (!printer.getPrintService().equals(this.defaultPS)) continue;
            return printer;
        }
        return null;
    }

    public Printer findPrinter(String printerName) {
        this.currentPrinter = null;
        if (printerName == null) {
            this.currentPrinter = this.getDefaultPrinter();
        } else {
            Printer printer;
            ListIterator<Printer> containsMatch;
            ListIterator<Printer> exactMatch = this.printerList.listIterator();
            while (exactMatch.hasNext()) {
                Printer printer2 = exactMatch.next();
                if (!printer2.getName().equals(printerName)) continue;
                this.currentPrinter = printer2;
                break;
            }
            if (this.currentPrinter == null) {
                containsMatch = this.printerList.listIterator();
                while (containsMatch.hasNext()) {
                    printer = containsMatch.next();
                    if (printer.getName().indexOf(printerName) == -1) continue;
                    this.currentPrinter = printer;
                    break;
                }
            }
            if (this.currentPrinter == null) {
                containsMatch = this.printerList.listIterator();
                while (containsMatch.hasNext()) {
                    printer = containsMatch.next();
                    if (printer.getName().toLowerCase().indexOf(printerName.toLowerCase()) == -1) continue;
                    this.currentPrinter = printer;
                    break;
                }
            }
        }
        if (this.currentPrinter != null) {
            LogIt.log("Found printer \"" + this.currentPrinter.getName() + "\".");
        } else {
            LogIt.log(Level.WARNING, "Could not find printer with name containing \"" + printerName + "\".");
        }
        return this.currentPrinter;
    }

    public void setPrinter(int printerIndex) {
        this.currentPrinter = printerIndex >= 0 ? this.printerList.get(printerIndex) : this.getDefaultPrinter();
        LogIt.log("Selecting " + (printerIndex >= 0 ? "printer " + printerIndex + ": \"" : " default printer \"") + this.currentPrinter.getName() + "\".");
    }

    public String getPrinter() {
        if (this.currentPrinter != null) {
            return this.currentPrinter.getName();
        }
        return null;
    }

    public String getLastPrinter() {
        if (this.lastPrinterName != null) {
            return this.lastPrinterName;
        }
        return null;
    }

    public void setPaperSize(PaperFormat paperSize) {
        this.paperSize = paperSize;
    }

    public void clearPaperSize() {
        this.paperSize = null;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public void setLeftMargin(int leftMargin) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.setLeftMargin(leftMargin);
    }

    public void setTopMargin(int topMargin) {
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.setTopMargin(topMargin);
    }

    public boolean getLogPostScriptFeatures() {
        return this.logPSFeatures;
    }

    public void setLogPostScriptFeatures(boolean logPSFeatures) {
        this.logPSFeatures = logPSFeatures;
        if (this.currentJob != null) {
            this.currentJob.setLogPostScriptFeatures(logPSFeatures);
        }
        LogIt.log("Console logging of PostScript printing features set to \"" + logPSFeatures + "\"");
    }

    public void setEndOfDocument(String endOfDocument) {
        this.endOfDocument = endOfDocument;
        LogIt.log("End of Document set to " + this.endOfDocument);
    }

    public void setCopies(int copies) {
        LogIt.log(Level.INFO, "[PrintSpooler] Copies set to " + copies);
        if (this.currentJob == null) {
            this.createJob();
        }
        this.currentJob.setCopies(copies);
    }

    public void setDocumentsPerSpool(int docsPerSpool) {
        this.docsPerSpool = docsPerSpool;
        LogIt.log("Documents per Spool set to " + this.docsPerSpool);
    }

    public String getFileData(ByteArrayBuilder url, Charset charset) {
        String data = null;
        try {
            String file = new String(url.getByteArray(), charset.name());
            data = new String(FileUtilities.readRawFile(file), charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Unsupported encoding.", ex);
        }
        catch (IOException ex) {
            LogIt.log(Level.SEVERE, "Could not retrieve file data.", ex);
        }
        return data;
    }

    public void findNetworkInfo() {
        if (this.networkUtilities == null) {
            try {
                this.networkUtilities = new NetworkUtilities(this);
            }
            catch (SocketException ex) {
                LogIt.log(Level.SEVERE, "Socket error.", ex);
            }
            catch (ReflectException ex) {
                LogIt.log(Level.SEVERE, "Reflection error.", ex);
            }
            catch (UnknownHostException ex) {
                LogIt.log(Level.SEVERE, "Unknown host.", ex);
            }
        }
        this.networkUtilities.gatherNetworkInfo();
    }

    public void doneFindingNetworkInfo() {
        this.macAddress = this.networkUtilities.getHardwareAddress();
        this.ipAddress = this.networkUtilities.getInetAddress();
        LogIt.log("Found Network Adapter. MAC: " + this.macAddress + " IP: " + this.ipAddress);
        this.btools.notifyBrowser("qzDoneFindingNetwork");
    }

    public String getMac() {
        return this.macAddress;
    }

    public String getIP() {
        return this.ipAddress;
    }

    public void useAlternatePrinting(boolean alternatePrint) {
        this.alternatePrint = alternatePrint;
        if (this.currentJob != null) {
            this.currentJob.setAlternatePrinting(alternatePrint);
        }
        LogIt.log("Alternate printing set to " + alternatePrint);
    }

    public boolean isAlternatePrinting() {
        return this.alternatePrint;
    }

    public void findPorts() {
        if (this.serialEnabled) {
            this.serialPrinter.findPorts();
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public String getPorts() {
        if (this.serialEnabled) {
            return this.serialPrinter.getPorts();
        }
        LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        return "";
    }

    public void openPort(String portName) {
        if (this.serialEnabled) {
            this.serialPrinter.openPort(portName);
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public void closePort(String portName) {
        if (this.serialEnabled) {
            this.serialPrinter.closePort(portName, true);
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public void closePort(String portName, boolean warnClosed) {
        if (this.serialEnabled) {
            this.serialPrinter.closePort(portName, warnClosed);
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public void setSerialBegin(ByteArrayBuilder serialBegin) {
        if (this.serialEnabled) {
            this.serialPrinter.setSerialBegin(serialBegin);
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public void setSerialEnd(ByteArrayBuilder serialEnd) {
        if (this.serialEnabled) {
            this.serialPrinter.setSerialEnd(serialEnd);
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public void setSerialProperties(String baud, String dataBits, String stopBits, String parity, String flowControl) {
        if (this.serialEnabled) {
            this.serialPrinter.setSerialProperties(baud, dataBits, stopBits, parity, flowControl);
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public void sendSerialData(String serialData) {
        if (this.serialEnabled) {
            this.serialPrinter.send(serialData);
        } else {
            LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        }
    }

    public String getReturnData() {
        if (this.serialEnabled) {
            return this.serialPrinter.getReturnData();
        }
        LogIt.log(Level.WARNING, "Serial functionality has been disabled.");
        return "";
    }

    public void setException(Throwable t) {
        this.exception = t;
    }

    public void clearException() {
        this.exception = null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setDefaultPrinterOnly(String defaultPrinterOnlyString) {
        if ("true".equals(defaultPrinterOnlyString)) {
            this.defaultPrinterOnly = true;
        }
    }
}

