/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.applet.Applet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import qz.Base64;
import qz.BrowserTools;
import qz.ByteArrayBuilder;
import qz.ByteUtilities;
import qz.LogIt;
import qz.PaperFormat;
import qz.PrintSpooler;
import qz.Printer;
import qz.json.JSONArray;

public class PrintApplet
extends Applet {
    public static final String VERSION = "1.9.9.4";
    private BrowserTools btools;
    private PrintSpooler spooler;
    private Charset charset;

    @Override
    public void start() {
        super.start();
        LogIt.log("QZ-PRINT " + this.getVersion());
        LogIt.log("Applet Started");
        this.btools = new BrowserTools(this);
        this.spooler = new PrintSpooler();
        this.spooler.setApplet(this);
        String defaultPrinterOnlyString = this.getParameter("default_printer_only");
        if (defaultPrinterOnlyString != null) {
            LogIt.log("Set defaultPrinterOnly to " + defaultPrinterOnlyString);
            this.spooler.setDefaultPrinterOnly(defaultPrinterOnlyString);
        }
        new Thread(this.spooler).start();
        this.charset = Charset.defaultCharset();
    }

    @Override
    public void stop() {
        this.spooler.closePort("", false);
        super.stop();
    }

    public void cancelJob(int jobIndex) {
        this.spooler.cancelJob(jobIndex);
    }

    public String getQueueInfo() {
        JSONArray queueInfo = this.spooler.getQueueInfo();
        if (queueInfo != null) {
            return queueInfo.toString();
        }
        return new JSONArray().toString();
    }

    public String getJobInfo(int jobIndex) {
        return this.spooler.getJobInfo(jobIndex);
    }

    public void findPrinter() {
        this.findPrinter(null);
    }

    public String findPrinter(String printerName) {
        Printer p = null;
        if (this.spooler.getPrinterList() != null) {
            p = this.spooler.findPrinter(printerName);
        }
        this.btools.notifyBrowser("qzDoneFinding");
        return p == null ? null : p.getName();
    }

    public String getPrinter() {
        return this.spooler.getPrinter();
    }

    public String getLastPrinter() {
        return this.spooler.getLastPrinter();
    }

    public String getPrinters() {
        if (this.spooler.getPrinterList() != null) {
            return this.spooler.getPrinters();
        }
        return "";
    }

    public void setPrinter(int printerIndex) {
        this.spooler.setPrinter(printerIndex);
    }

    public void append(String data) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(data, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append data.", ex);
        }
        this.spooler.append(bytes, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void append64(String base64) {
        byte[] base64Array = null;
        try {
            base64Array = Base64.decode(base64);
        }
        catch (IOException ex) {
            LogIt.log(Level.SEVERE, "Could not append data.", ex);
        }
        ByteArrayBuilder data = new ByteArrayBuilder(base64Array);
        this.spooler.append(data, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendHex(String hexString) {
        byte[] bytes = ByteUtilities.hexStringToByteArray(hexString);
        ByteArrayBuilder data = new ByteArrayBuilder(bytes);
        this.spooler.append(data, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendImage(String imagePath, String lang) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(imagePath, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append image.", ex);
        }
        this.spooler.appendImage(bytes, this.charset, lang, 0, 0);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendImage(String imagePath, String lang, int imageX, int imageY) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(imagePath, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append image.", ex);
        }
        this.spooler.appendImage(bytes, this.charset, lang, imageX, imageY);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendImage(String imagePath, String lang, String dotDensityString) {
        int dotDensity = 32;
        if (dotDensityString.equalsIgnoreCase("single")) {
            dotDensity = 32;
        } else if (dotDensityString.equalsIgnoreCase("double")) {
            dotDensity = 33;
        } else if (dotDensityString.equalsIgnoreCase("triple")) {
            dotDensity = 39;
        } else {
            LogIt.log(Level.WARNING, "Cannot translate dotDensity value of '" + dotDensityString + "'.  Using '" + dotDensity + "'.");
        }
        this.appendImage(imagePath, lang, dotDensity);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendImage(String imagePath, String lang, int dotDensity) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(imagePath, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append image.", ex);
        }
        this.spooler.appendImage(bytes, this.charset, lang, dotDensity);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendImage(String url) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(url, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append image.", ex);
        }
        this.spooler.appendPSImage(bytes, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendXML(String url, String xmlTag) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(url, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append XML.", ex);
        }
        this.spooler.appendXML(bytes, this.charset, xmlTag);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendFile(String url) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(url, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append file.", ex);
        }
        this.spooler.appendFile(bytes, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendRTF(String url) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(url, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "Could not append file.", ex);
        }
        this.spooler.appendRtfFile(bytes, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendHTML(String html) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(html, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "HTML could not be appended.", ex);
        }
        this.spooler.appendHTML(bytes, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public void appendPDF(String url) {
        ByteArrayBuilder bytes = new ByteArrayBuilder();
        try {
            bytes.append(url, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.SEVERE, "PDF File could not be appended.", ex);
        }
        this.spooler.appendPDF(bytes, this.charset);
        this.btools.notifyBrowser("qzDoneAppending");
    }

    public boolean print() {
        Boolean success = this.spooler.print();
        if (success.booleanValue()) {
            LogIt.log("Print Successful");
        } else {
            LogIt.log(Level.WARNING, "Print Failed");
        }
        this.btools.notifyBrowser("qzDonePrinting");
        return success;
    }

    public void printToFile(String filePath) {
        this.spooler.printToFile(filePath);
        this.btools.notifyBrowser("qzDonePrinting");
    }

    public void printToHost(String jobHost, int jobPort) {
        this.spooler.printToHost(jobHost, jobPort);
        this.btools.notifyBrowser("qzDonePrinting");
    }

    public String getVersion() {
        return VERSION;
    }

    public Throwable getException() {
        return this.spooler.getException();
    }

    public void clearException() {
        this.spooler.clearException();
    }

    public void setEncoding(String charset) {
        LogIt.log("Default charset encoding: " + Charset.defaultCharset().name());
        try {
            this.charset = Charset.forName(charset);
            LogIt.log("Current applet charset encoding: " + this.charset.name());
        }
        catch (IllegalCharsetNameException e) {
            LogIt.log(Level.WARNING, "Could not find specified charset encoding: " + charset + ". Using default.", e);
        }
    }

    public void setPaperSize(String width, String height) {
        PaperFormat paperSize = PaperFormat.parseSize(width, height);
        this.spooler.setPaperSize(paperSize);
        LogIt.log(Level.INFO, "Set paper size to " + paperSize.getWidth() + paperSize.getUnitDescription() + "x" + paperSize.getHeight() + paperSize.getUnitDescription());
    }

    public void clearPaperSize() {
        this.spooler.clearPaperSize();
        LogIt.log(Level.INFO, "Paper size has been cleared.");
    }

    public void setPaperSize(float width, float height) {
        PaperFormat paperSize = new PaperFormat(width, height);
        this.spooler.setPaperSize(paperSize);
        LogIt.log(Level.INFO, "Set paper size to " + paperSize.getWidth() + paperSize.getUnitDescription() + "x" + paperSize.getHeight() + paperSize.getUnitDescription());
    }

    public void setPaperSize(float width, float height, String units) {
        PaperFormat paperSize = PaperFormat.parseSize("" + width, "" + height, units);
        this.spooler.setPaperSize(paperSize);
        LogIt.log(Level.INFO, "Set paper size to " + paperSize.getWidth() + paperSize.getUnitDescription() + "x" + paperSize.getHeight() + paperSize.getUnitDescription());
    }

    public void setAutoSize(boolean autoSize) {
        this.spooler.setAutoSize(autoSize);
        LogIt.log(Level.INFO, "Auto size has been set to " + Boolean.toString(autoSize));
    }

    public void setLeftMargin(int leftMargin) {
        this.spooler.setLeftMargin(leftMargin);
        LogIt.log(Level.INFO, "Left margin set to " + leftMargin);
    }

    public void setTopMargin(int topMargin) {
        this.spooler.setTopMargin(topMargin);
        LogIt.log(Level.INFO, "Top margin set to " + topMargin);
    }

    public boolean getLogPostScriptFeatures() {
        return this.spooler.getLogPostScriptFeatures();
    }

    public void setLogPostScriptFeatures(boolean logPSFeatures) {
        this.spooler.setLogPostScriptFeatures(logPSFeatures);
    }

    public void setCopies(int copies) {
        this.spooler.setCopies(copies);
    }

    public void setEndOfDocument(String endOfDocument) {
        this.spooler.setEndOfDocument(endOfDocument);
    }

    public void setDocumentsPerSpool(int docsPerSpool) {
        this.spooler.setDocumentsPerSpool(docsPerSpool);
    }

    public void findNetworkInfo() {
        this.spooler.findNetworkInfo();
    }

    public String getMac() {
        return this.spooler.getMac();
    }

    public String getIP() {
        return this.spooler.getIP();
    }

    public void useAlternatePrinting() {
        this.useAlternatePrinting(true);
    }

    public void useAlternatePrinting(boolean alternatePrint) {
        this.spooler.useAlternatePrinting(alternatePrint);
    }

    public boolean isAlternatePrinting() {
        return this.spooler.isAlternatePrinting();
    }

    public void findPorts() {
        this.spooler.findPorts();
    }

    public String getPorts() {
        return this.spooler.getPorts();
    }

    public void openPort(String portName) {
        this.spooler.openPort(portName);
    }

    public void closePort(String portName) {
        this.spooler.closePort(portName);
    }

    public void setSerialBegin(String serialBegin) {
        ByteArrayBuilder serialBeginBytes = new ByteArrayBuilder(serialBegin.getBytes());
        this.spooler.setSerialBegin(serialBeginBytes);
    }

    public void setSerialEnd(String serialEnd) {
        ByteArrayBuilder serialEndBytes = new ByteArrayBuilder(serialEnd.getBytes());
        this.spooler.setSerialEnd(serialEndBytes);
    }

    public void setSerialProperties(int baud, int dataBits, String stopBits, int parity, String flowControl) {
        this.setSerialProperties(Integer.toString(baud), Integer.toString(dataBits), stopBits, Integer.toString(parity), flowControl);
    }

    public void setSerialProperties(String baud, String dataBits, String stopBits, String parity, String flowControl) {
        this.spooler.setSerialProperties(baud, dataBits, stopBits, parity, flowControl);
    }

    public void send(String portName, String serialData) {
        this.spooler.sendSerialData(serialData);
    }

    public String getReturnData() {
        return this.spooler.getReturnData();
    }

    @Deprecated
    public boolean isDoneAppending() {
        LogIt.log(Level.WARNING, "isDoneAppending() has been deprecated and will be removed in a future version.");
        return true;
    }

    @Deprecated
    public boolean isDonePrinting() {
        LogIt.log(Level.WARNING, "isDonePrinting() has been deprecated and will be removed in a future version. Try using getQueueInfo().");
        return true;
    }

    @Deprecated
    public boolean getAllowMultipleInstances() {
        LogIt.log(Level.WARNING, "getAllowMultipleInstances() has been deprecated and will be removed in a future version. This functionality is no longer supported.");
        return false;
    }

    @Deprecated
    public void allowMultipleInstances(Boolean newValue) {
        LogIt.log(Level.WARNING, "allowMultipleInstances() has been deprecated and will be removed in a future version. This functionality is no longer supported.");
    }

    @Deprecated
    public boolean isDoneFinding() {
        LogIt.log(Level.WARNING, "isDoneFinding() has been deprecated and will be removed in a future version. This functionality is no longer needed.");
        return true;
    }

    @Deprecated
    public boolean printPS() {
        LogIt.log(Level.WARNING, "printPS() has been deprecated and will be removed in a future version. You can use \"print()\" for all types of print jobs.");
        return this.print();
    }

    @Deprecated
    public boolean printHTML() {
        LogIt.log(Level.WARNING, "printHTML() has been deprecated and will be removed in a future version. You can use \"print()\" for all types of print jobs.");
        return this.print();
    }
}

