/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import qz.ByteUtilities;
import qz.LogIt;
import qz.NetworkUtilities;
import qz.reflection.Reflect;

public class NetworkInfoFinder
implements Runnable {
    NetworkUtilities utils;
    String hostname;
    int port;

    NetworkInfoFinder(NetworkUtilities utils, String hostname, int port) {
        this.utils = utils;
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void run() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Socket socket = new Socket();
                    InetSocketAddress endpoint = new InetSocketAddress(NetworkInfoFinder.this.hostname, NetworkInfoFinder.this.port);
                    socket.connect(endpoint);
                    InetAddress localAddress = socket.getLocalAddress();
                    NetworkInfoFinder.this.utils.setIpAddress(localAddress.getHostAddress());
                    socket.close();
                    System.out.println(localAddress.getHostAddress());
                    NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localAddress);
                    Reflect r = Reflect.on(networkInterface);
                    byte[] b = (byte[])r.call("getHardwareAddress").get();
                    if (b != null && b.length > 0) {
                        NetworkInfoFinder.this.utils.setMacAddress(ByteUtilities.bytesToHex(b));
                    }
                }
                catch (IOException ex) {
                    LogIt.log(Level.WARNING, "IO Exception. Could not find network info.", ex);
                }
                NetworkInfoFinder.this.utils.doneFindingNetworkInfo();
                return null;
            }
        });
    }
}

