/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import netscape.javascript.JSObject;
import qz.Base64;
import qz.ByteArrayBuilder;
import qz.ByteUtilities;
import qz.FileUtilities;
import qz.ImageWrapper;
import qz.LanguageType;
import qz.LogIt;
import qz.PaperFormat;
import qz.PrintHTML;
import qz.PrintPostScript;
import qz.PrintRaw;
import qz.PrintServiceMatcher;
import qz.SerialIO;
import qz.exception.NullCommandException;
import qz.exception.NullPrintServiceException;
import qz.exception.SerialException;
import qz.json.JSONArray;

public class PrintApplet
extends Applet
implements Runnable {
    private static final AtomicReference<Thread> thisThread = new AtomicReference<Object>(null);
    public static final String VERSION = "1.6.6";
    private static final long serialVersionUID = 2787955484074291340L;
    public static final int APPEND_XML = 1;
    public static final int APPEND_RAW = 2;
    public static final int APPEND_IMAGE = 3;
    public static final int APPEND_IMAGE_PS = 4;
    public static final int APPEND_PDF = 8;
    public static final int APPEND_HTML = 16;
    private LanguageType lang;
    private int appendType;
    private long sleep;
    private PrintService ps;
    private PrintRaw printRaw;
    private SerialIO serialIO;
    private PrintPostScript printPS;
    private PrintHTML printHTML;
    private Throwable t;
    private PaperFormat paperSize;
    private boolean startFindingPrinters;
    private boolean doneFindingPrinters;
    private boolean startPrinting;
    private boolean donePrinting;
    private boolean startAppending;
    private boolean doneAppending;
    private boolean startFindingPorts;
    private boolean doneFindingPorts;
    private boolean startSending;
    private boolean doneSending;
    private boolean autoSetSerialProperties = false;
    private boolean startOpeningPort;
    private boolean doneOpeningPort;
    private boolean startClosingPort;
    private boolean doneClosingPort;
    private String serialPortName;
    private int serialPortIndex = -1;
    private boolean running;
    private boolean reprint;
    private boolean psPrint;
    private boolean htmlPrint;
    private boolean alternatePrint;
    private boolean logFeaturesPS;
    private int imageX = 0;
    private int imageY = 0;
    private int dotDensity = 32;
    private boolean allowMultiple;
    private String jobName;
    private String file;
    private String xmlTag;
    private String printer;
    private Integer copies;
    private Charset charset = Charset.defaultCharset();
    private int documentsPerSpool = 0;
    private String endOfDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logStart();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    PrintApplet.this.startJavaScriptListener();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            LogIt.log("Error starting main JavaScript thread.  All else will fail.", e);
            this.set(e);
        }
        finally {
            this.logStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJavaScriptListener() {
        this.notifyBrowser("jzebraReady");
        while (this.running) {
            try {
                Thread.sleep(this.sleep);
                if (this.startAppending) {
                    try {
                        switch (this.appendType) {
                            case 16: {
                                this.appendHTML(new String(FileUtilities.readRawFile(this.file), this.charset.name()));
                            }
                            case 1: {
                                this.append64(FileUtilities.readXMLFile(this.file, this.xmlTag));
                                break;
                            }
                            case 2: {
                                this.getPrintRaw().append(FileUtilities.readRawFile(this.file));
                                break;
                            }
                            case 4: {
                                this.readImage();
                                break;
                            }
                            case 3: {
                                BufferedImage bi;
                                if (this.isBase64Image(this.file)) {
                                    byte[] imageData = Base64.decode(this.file.split(",")[1]);
                                    bi = ImageIO.read(new ByteArrayInputStream(imageData));
                                } else {
                                    bi = ImageIO.read(new URL(this.file));
                                }
                                ImageWrapper iw = new ImageWrapper(bi, this.lang);
                                iw.setCharset(this.charset);
                                iw.setDotDensity(this.dotDensity);
                                iw.setxPos(this.imageX);
                                iw.setyPos(this.imageY);
                                this.getPrintRaw().append(iw.getImageCommand());
                                break;
                            }
                            case 8: {
                                this.readBinaryFile();
                                break;
                            }
                        }
                    }
                    catch (Throwable t) {
                        LogIt.log("Error appending data", t);
                        this.set(t);
                    }
                    this.startAppending = false;
                    this.setDoneAppending(true);
                }
                if (this.startFindingPorts) {
                    this.logFindPorts();
                    this.startFindingPorts = false;
                    this.getSerialIO().fetchSerialPorts();
                    this.setDoneFindingPorts(true);
                }
                if (this.startOpeningPort) {
                    this.logOpeningPort();
                    this.startOpeningPort = false;
                    try {
                        if (this.serialPortIndex != -1) {
                            this.getSerialIO().open(this.serialPortIndex);
                        } else {
                            this.getSerialIO().open(this.serialPortName);
                        }
                        if (this.autoSetSerialProperties) {
                            this.getSerialIO().autoSetProperties();
                        }
                    }
                    catch (Throwable t) {
                        this.set(t);
                    }
                    this.setDoneOpeningPort(true);
                }
                if (this.startClosingPort) {
                    this.logClosingPort();
                    this.startClosingPort = false;
                    try {
                        this.getSerialIO().close();
                    }
                    catch (Throwable t) {
                        this.set(t);
                    }
                    this.setDoneClosingPort(true);
                }
                if (this.startFindingPrinters) {
                    this.logFindPrinter();
                    this.startFindingPrinters = false;
                    if (this.printer == null) {
                        this.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
                    } else {
                        this.setPrintService(PrintServiceMatcher.findPrinter(this.printer));
                    }
                    this.setDoneFindingPrinters(true);
                }
                if (this.startSending) {
                    try {
                        this.startSending = false;
                        this.logCommands(new String(this.getSerialIO().getInputBuffer().getByteArray(), this.charset.name()));
                        this.getSerialIO().send();
                        this.doneSending = true;
                    }
                    catch (Throwable t) {
                        this.set(t);
                    }
                }
                if (this.serialIO != null && this.serialIO.getOutput() != null) {
                    try {
                        this.notifyBrowser("jzebraSerialReturned", new Object[]{this.serialIO.getPortName(), new String(this.serialIO.getOutput(), this.charset.name())}, false);
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.set(ex);
                    }
                    this.serialIO.clearOutput();
                }
                if (!this.startPrinting) continue;
                this.logPrint();
                try {
                    this.startPrinting = false;
                    if (this.htmlPrint) {
                        this.logAndPrint(this.getPrintHTML());
                        continue;
                    }
                    if (this.psPrint) {
                        this.logAndPrint(this.getPrintPS());
                        continue;
                    }
                    if (this.isRawAutoSpooling()) {
                        LinkedList<ByteArrayBuilder> pages = ByteUtilities.splitByteArray(this.getPrintRaw().getByteArray(), this.endOfDocument.getBytes(this.charset.name()), this.documentsPerSpool);
                        LogIt.log(Level.INFO, "Automatically spooling to " + pages.size() + " separate print job(s)");
                        for (ByteArrayBuilder b : pages) {
                            this.logAndPrint(this.getPrintRaw(), b.getByteArray());
                        }
                        if (this.reprint) continue;
                        this.getPrintRaw().clear();
                        continue;
                    }
                    this.logAndPrint(this.getPrintRaw());
                }
                catch (PrintException e) {
                    this.set(e);
                }
                catch (PrinterException e) {
                    this.set(e);
                }
                catch (UnsupportedEncodingException e) {
                    this.set(e);
                }
                catch (IOException e) {
                    this.set(e);
                }
                finally {
                    this.setDonePrinting(true);
                    this.getPrintRaw().clear();
                }
            }
            catch (InterruptedException e) {
                this.set(e);
            }
        }
    }

    public void useAlternatePrinting() {
        this.useAlternatePrinting(true);
    }

    public void useAlternatePrinting(boolean alternatePrint) {
        this.alternatePrint = alternatePrint;
    }

    public boolean isAlternatePrinting() {
        return this.alternatePrint;
    }

    private boolean isRawAutoSpooling() throws UnsupportedEncodingException {
        return this.documentsPerSpool > 0 && this.endOfDocument != null && !this.getPrintRaw().isClear() && this.getPrintRaw().contains(this.endOfDocument);
    }

    private void setDonePrinting(boolean donePrinting) {
        this.donePrinting = donePrinting;
        this.notifyBrowser("jzebraDonePrinting");
    }

    private void setDoneFindingPrinters(boolean doneFindingPrinters) {
        this.doneFindingPrinters = doneFindingPrinters;
        this.notifyBrowser("jzebraDoneFinding", true);
        this.notifyBrowser("jzebraDoneFindingPrinters", false);
    }

    private void setDoneOpeningPort(boolean doneOpeningPort) {
        this.doneOpeningPort = doneOpeningPort;
        this.notifyBrowser("jzebraDoneOpeningPort", this.getSerialIO().getPortName());
    }

    private void setDoneClosingPort(boolean doneClosingPort) {
        this.doneClosingPort = doneClosingPort;
        this.notifyBrowser("jzebraDoneClosingPort", this.serialPortName);
    }

    private void setDoneFindingPorts(boolean doneFindingPorts) {
        this.doneFindingPorts = doneFindingPorts;
        this.notifyBrowser("jzebraDoneFindingPorts", false);
    }

    private void setDoneAppending(boolean doneAppending) {
        this.doneAppending = doneAppending;
        this.notifyBrowser("jzebraDoneAppending");
    }

    public void logPostScriptFeatures(boolean logFeaturesPS) {
        this.setLogPostScriptFeatures(logFeaturesPS);
    }

    public void setLogPostScriptFeatures(boolean logFeaturesPS) {
        this.logFeaturesPS = logFeaturesPS;
        LogIt.log("Console logging of PostScript printing features set to \"" + logFeaturesPS + "\"");
    }

    public boolean getLogPostScriptFeatures() {
        return this.logFeaturesPS;
    }

    private void processParameters() {
        this.jobName = "QZ-PRINT ___ Printing";
        this.running = true;
        this.startPrinting = false;
        this.donePrinting = true;
        this.startFindingPrinters = false;
        this.doneFindingPrinters = true;
        this.startFindingPorts = false;
        this.doneFindingPorts = true;
        this.startOpeningPort = false;
        this.startClosingPort = false;
        this.startSending = false;
        this.doneSending = true;
        this.startAppending = false;
        this.doneAppending = true;
        this.sleep = this.getParameter("sleep", 100L);
        this.psPrint = false;
        this.appendType = 0;
        this.allowMultiple = false;
        this.logFeaturesPS = false;
        this.alternatePrint = false;
        String printer = this.getParameter("printer", null);
        if (printer != null) {
            this.findPrinter(printer);
        }
    }

    public void notifyBrowser(String function, String s) {
        this.notifyBrowser(function, new Object[]{s}, false);
    }

    public void notifyBrowser(String function, Object[] o, boolean silent) {
        block2: {
            try {
                JSObject.getWindow((Applet)this).call(function, o);
            }
            catch (Exception e) {
                if (silent) break block2;
                LogIt.log(Level.WARNING, "Tried calling JavaScript function \"" + function + "\" through web browser but it has not been implemented (" + e.getLocalizedMessage() + ")");
            }
        }
    }

    private void notifyBrowser(String function) {
        this.notifyBrowser(function, new Object[]{null}, false);
    }

    private void notifyBrowser(String function, boolean silent) {
        this.notifyBrowser(function, new Object[]{null}, silent);
    }

    private String getParameter(String name, String defaultVal) {
        if (name != null) {
            try {
                String retVal = super.getParameter(name);
                retVal = this.isBlank(retVal) ? super.getParameter(name.toUpperCase()) : retVal;
                return this.isBlank(retVal) ? defaultVal : retVal;
            }
            catch (NullPointerException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    private long getParameter(String name, long defaultVal) {
        return Long.parseLong(this.getParameter(name, "" + defaultVal));
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().equals("");
    }

    public String getPrinters() {
        return PrintServiceMatcher.getPrinterListing();
    }

    public String getPorts() {
        return this.getSerialIO().getSerialPorts();
    }

    public void append64(String base64) {
        try {
            this.getPrintRaw().append(Base64.decode(base64));
        }
        catch (IOException e) {
            this.set(e);
        }
    }

    public void appendHTMLFile(String url) {
        this.appendType = 16;
        this.appendFromThread(url, this.appendType);
    }

    public void appendHtmlFile(String url) {
        this.appendHTMLFile(url);
    }

    public void appendHtml(String html) {
        this.appendHTML(html);
    }

    public void appendHTML(String html) {
        this.getPrintHTML().append(html);
    }

    public void appendXML(String url, String xmlTag) {
        this.appendFromThread(url, 1);
        this.xmlTag = xmlTag;
    }

    public void appendFile(String url) {
        this.appendFromThread(url, 2);
    }

    public void appendImage(String url) {
        this.appendFromThread(url, 4);
    }

    public void appendPDF(String url) {
        this.appendFromThread(url, 8);
    }

    public void setLanguage(String lang) {
        this.lang = LanguageType.getType(lang);
    }

    public void appendImage(String imageFile, String lang) {
        this.setLanguage(lang);
        this.appendFromThread(imageFile, 3);
    }

    public void appendImage(String imageFile, String lang, int dotDensity) {
        this.dotDensity = dotDensity;
        this.setLanguage(lang);
        this.appendFromThread(imageFile, 3);
    }

    public void appendImage(String imageFile, String lang, String dotDensity) {
        if (dotDensity.equalsIgnoreCase("single")) {
            this.dotDensity = 32;
        } else if (dotDensity.equalsIgnoreCase("double")) {
            this.dotDensity = 33;
        } else if (dotDensity.equalsIgnoreCase("triple")) {
            this.dotDensity = 39;
        } else {
            LogIt.log(Level.WARNING, "Cannot translate dotDensity value of '" + dotDensity + "'.  Using '" + this.dotDensity + "'.");
        }
        this.setLanguage(lang);
        this.appendFromThread(imageFile, 3);
    }

    public void appendImage(String imageFile, String lang, int image_x, int image_y) {
        this.imageX = image_x;
        this.imageY = image_y;
        this.appendImage(imageFile, lang);
    }

    private void appendFromThread(String file, int appendType) {
        this.startAppending = true;
        this.doneAppending = false;
        this.appendType = appendType;
        this.file = file;
    }

    public String getOrientation() {
        return this.paperSize.getOrientationDescription();
    }

    public void printToFile() {
        this.printToFile(null);
    }

    public void printToHost(String host) {
        this.printToHost(host, 9100);
    }

    public void printToHost(String host, String port) {
        try {
            this.printToHost(host, Integer.parseInt(host));
        }
        catch (Throwable t) {
            this.set(t);
        }
    }

    public void printToHost(String host, int port) {
        if (!ByteUtilities.isBlank(host) && port > 0) {
            this.getPrintRaw().setOutputSocket(host, port);
        } else {
            this.set(new NullPrintServiceException("Invalid port or host specified.  Port values must be non-zero posistive integers.  Host values must not be empty"));
        }
        this.print();
    }

    public void printToFile(String outputPath) {
        if (!ByteUtilities.isBlank(outputPath)) {
            this.getPrintRaw().setOutputPath(outputPath);
        } else {
            this.set(new NullPrintServiceException("Blank output path supplied"));
        }
        this.print();
    }

    private void readImage() {
        try {
            if (this.isBase64Image(this.file)) {
                this.getPrintPS().setImage(Base64.decode(this.file.split(",")[1]));
            } else {
                this.getPrintPS().setImage(ImageIO.read(new URL(this.file)));
            }
        }
        catch (IOException ex) {
            LogIt.log(Level.WARNING, "Error reading specified image", ex);
        }
    }

    private boolean isBase64Image(String path) {
        return path.startsWith("data:image/") && path.contains(";base64,");
    }

    private PrintPostScript getPrintPS() {
        if (this.printPS == null) {
            this.printPS = new PrintPostScript();
            this.printPS.setPrintParameters(this);
        }
        return this.printPS;
    }

    private PrintHTML getPrintHTML() {
        if (this.printHTML == null) {
            this.printHTML = new PrintHTML();
            this.printHTML.setPrintParameters(this);
        }
        return this.printHTML;
    }

    public void readBinaryFile() {
        ByteBuffer data = null;
        try {
            int len;
            URLConnection con = new URL(this.file).openConnection();
            InputStream in = con.getInputStream();
            int size = con.getContentLength();
            ByteArrayOutputStream out = size != -1 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream(20480);
            byte[] buffer = new byte[512];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
            byte[] array = out.toByteArray();
            data = ByteBuffer.wrap(array);
        }
        catch (Exception e) {
            LogIt.log(Level.WARNING, "Error reading/parsing specified PDF file", e);
        }
        this.getPrintPS().setPDF(data);
    }

    public void printPersistent() {
        this.startPrinting = true;
        this.donePrinting = false;
        this.reprint = true;
    }

    public void appendHex(String s) {
        try {
            this.getPrintRaw().append(ByteUtilities.hexStringToByteArray(s));
        }
        catch (NumberFormatException e) {
            this.set(e);
        }
    }

    public void appendJSONArray(String s) {
        JSONArray array = new JSONArray(s);
        if (array == null || array.length() < 0) {
            this.set(new NullCommandException("Empty or null JSON Array provided.  Cannot append raw data."));
            return;
        }
        Object o = array.get(0);
        if (o instanceof Integer) {
            LogIt.log("Interpreting JSON data as Integer array.  Will automatically convert to bytes.");
            byte[] b = new byte[array.length()];
            for (int i = 0; i < b.length; ++i) {
                if (!array.isNull(i)) {
                    b[i] = (byte)array.getInt(i);
                    continue;
                }
                LogIt.log(Level.WARNING, "Cannot parse null byte value.  Defaulting to 0x00");
                b[i] = 0;
            }
            this.getPrintRaw().append(b);
        } else if (o instanceof String) {
            LogIt.log("Interpreting JSON data as String array");
            for (int i = 0; i < array.length(); ++i) {
                if (!array.isNull(i)) {
                    try {
                        this.getPrintRaw().append(array.getString(i));
                    }
                    catch (UnsupportedEncodingException e) {
                        LogIt.log(Level.WARNING, "String encoding exception occured while parsing JSON.", e);
                    }
                    continue;
                }
                LogIt.log(Level.WARNING, "Cannot parse null String value.  Defaulting to blank");
            }
        } else {
            this.set(new NullCommandException("JSON Arrays of type " + o.getClass().getName() + " are not yet supported"));
        }
    }

    public void append(String s) {
        try {
            this.getPrintRaw().append(s.getBytes(this.charset.name()));
        }
        catch (UnsupportedEncodingException ex) {
            this.set(ex);
        }
    }

    public void appendNull() {
        this.getPrintRaw().append(new byte[]{0});
    }

    public void appendNUL() {
        this.appendNull();
    }

    public void appendNul() {
        this.appendNull();
    }

    public void clear() {
        this.getPrintRaw().clear();
    }

    public void print() {
        this.startPrinting = true;
        this.donePrinting = false;
        this.reprint = false;
    }

    public void printHTML() {
        this.htmlPrint = true;
        this.print();
    }

    public void printPS() {
        this.psPrint = true;
        this.print();
    }

    public void init() {
        if (!this.allowMultiple && thisThread.get() != null && thisThread.get().isAlive()) {
            LogIt.log(Level.WARNING, "init() called, but applet already seems to be running.  Ignoring.");
            return;
        }
        if (this.allowMultiple && thisThread.get() != null && thisThread.get().isAlive()) {
            LogIt.log(Level.INFO, "init() called, but applet already seems to be running.  Allowing.");
        }
        this.processParameters();
        thisThread.set(new Thread(this));
        super.init();
    }

    public void paint(Graphics g) {
    }

    public void start() {
        try {
            thisThread.get().start();
        }
        catch (Exception e) {
            this.set(e);
        }
        super.start();
    }

    public void stop() {
        this.running = false;
        thisThread.set(null);
        if (this.serialIO != null) {
            try {
                this.serialIO.close();
            }
            catch (Throwable t) {
                LogIt.log(Level.SEVERE, "Could not close port [" + this.serialIO.getPortName() + "].", t);
            }
        }
        super.stop();
    }

    public void destroy() {
        this.stop();
        super.destroy();
    }

    public void findPrinter() {
        this.findPrinter(null);
    }

    public void findPrinter(String printer) {
        this.startFindingPrinters = true;
        this.doneFindingPrinters = false;
        this.printer = printer;
    }

    public void findPorts() {
        this.startFindingPorts = true;
        this.doneFindingPorts = false;
    }

    public void setSerialBegin(String begin) {
        try {
            this.getSerialIO().setBegin(begin.getBytes(this.charset.name()));
        }
        catch (UnsupportedEncodingException ex) {
            this.set(ex);
        }
    }

    public void setSerialEnd(String end) {
        try {
            this.getSerialIO().setEnd(end.getBytes(this.charset.name()));
        }
        catch (UnsupportedEncodingException ex) {
            this.set(ex);
        }
    }

    public void send(String portName, String data) {
        try {
            if (!this.getSerialIO().isOpen()) {
                throw new SerialException("A port has not yet been opened.");
            }
            if (!this.getSerialIO().getPortName().equals(portName)) {
                throw new SerialException("Port specified [" + portName + "] " + "differs from previously opened port " + "[" + this.getSerialIO().getPortName() + "].  Applet currently " + "supports only one open port at a time.  Data not sent.");
            }
            this.getSerialIO().append(data.getBytes(this.charset.name()));
            this.startSending = true;
            this.doneSending = false;
        }
        catch (Throwable t) {
            this.set(t);
        }
    }

    public void sendHex(String portName, String data) {
        try {
            this.send(portName, new String(ByteUtilities.hexStringToByteArray(data), this.charset.name()));
        }
        catch (UnsupportedEncodingException ex) {
            this.set(ex);
        }
    }

    public void setSerialProperties(int baud, int dataBits, String stopBits, int parity, String flowControl) {
        this.setSerialProperties(Integer.toString(baud), Integer.toString(dataBits), stopBits, Integer.toString(parity), flowControl);
    }

    public void setSerialProperties(String baud, String dataBits, String stopBits, String parity, String flowControl) {
        try {
            this.getSerialIO().setProperties(baud, dataBits, stopBits, parity, flowControl);
        }
        catch (Throwable t) {
            this.set(t);
        }
    }

    public void openPort(String serialPortName) {
        this.openPort(serialPortName, false);
    }

    public void closePort(String portName) {
        if (this.getSerialIO().getPortName().equals(portName)) {
            this.startClosingPort = true;
            this.doneClosingPort = false;
        } else {
            this.set(new SerialException("Port specified [" + portName + "] " + "could not be closed. Please close " + "[" + this.getSerialIO().getPortName() + "] instead. " + "Applet currently supports only one open port at a time."));
        }
    }

    public void openPort(String serialPortName, boolean autoSetSerialProperties) {
        this.serialPortIndex = -1;
        this.serialPortName = serialPortName;
        this.startOpeningPort = true;
        this.doneOpeningPort = false;
        this.autoSetSerialProperties = autoSetSerialProperties;
    }

    public void openPort(int serialPortIndex) {
        this.openPort(serialPortIndex, false);
    }

    public void openPort(int serialPortIndex, boolean autoSetSerialProperties) {
        this.serialPortName = null;
        this.serialPortIndex = serialPortIndex;
        this.startOpeningPort = true;
        this.doneOpeningPort = false;
    }

    public boolean isDoneFinding() {
        return this.doneFindingPrinters;
    }

    public boolean isDoneFindingPorts() {
        return this.doneFindingPorts;
    }

    public boolean isDoneOpeningPort() {
        return this.doneOpeningPort;
    }

    public boolean isDoneClosingPort() {
        return this.doneClosingPort;
    }

    public boolean isDonePrinting() {
        return this.donePrinting;
    }

    public boolean isDoneAppending() {
        return this.doneAppending;
    }

    public boolean isDoneSending() {
        return this.doneSending;
    }

    public String getPrinter() {
        return this.ps == null ? null : this.ps.getName();
    }

    public SerialIO getSerialIO() {
        try {
            Class.forName("jssc.SerialPort");
            if (this.serialIO == null) {
                this.serialIO = new SerialIO();
            }
            return this.serialIO;
        }
        catch (Throwable t) {
            this.set(t);
            return null;
        }
    }

    private PrintRaw getPrintRaw() {
        if (this.printRaw == null) {
            this.printRaw = new PrintRaw();
            this.printRaw.setPrintParameters(this);
        }
        return this.printRaw;
    }

    public PrintService getPrintService() {
        return this.ps;
    }

    @Deprecated
    public String getPrinterName() {
        LogIt.log(Level.WARNING, "Function \"getPrinterName()\" has been deprecated since v. 1.2.3.  Please use \"getPrinter()\" instead.");
        return this.getPrinter();
    }

    public Throwable getError() {
        return this.getException();
    }

    public Throwable getException() {
        return this.t;
    }

    public void clearException() {
        this.t = null;
    }

    public String getExceptionMessage() {
        return this.t.getLocalizedMessage();
    }

    public long getSleepTime() {
        return this.sleep;
    }

    public String getVersion() {
        return VERSION;
    }

    public void setSleepTime(long sleep) {
        this.sleep = sleep;
    }

    public String getEndOfDocument() {
        return this.endOfDocument;
    }

    public void setEndOfDocument(String endOfPage) {
        this.endOfDocument = endOfPage;
    }

    public void setPrinter(int index) {
        this.setPrintService(PrintServiceMatcher.getPrinterList()[index]);
        LogIt.log("Printer set to index: " + index + ",  Name: " + this.ps.getName());
    }

    private void setPrintService(PrintService ps) {
        if (ps == null) {
            LogIt.log(Level.WARNING, "Ignoring null PrintService");
            return;
        }
        this.ps = ps;
        if (this.printHTML != null) {
            this.printHTML.setPrintService(ps);
        }
        if (this.printPS != null) {
            this.printPS.setPrintService(ps);
        }
        if (this.printRaw != null) {
            this.printRaw.setPrintService(ps);
        }
    }

    public int getDocumentsPerSpool() {
        return this.documentsPerSpool;
    }

    public void setDocumentsPerSpool(int pagesPer) {
        this.documentsPerSpool = pagesPer;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    private void set(Throwable t) {
        this.t = t;
        LogIt.log(t);
    }

    private void logStart() {
        LogIt.log("QZ-PRINT 1.6.6");
        LogIt.log("===== JAVASCRIPT LISTENER THREAD STARTED =====");
    }

    private void logStop() {
        LogIt.log("===== JAVASCRIPT LISTENER THREAD STOPPED =====");
    }

    private void logPrint() {
        LogIt.log("===== SENDING DATA TO THE PRINTER =====");
    }

    private void logFindPrinter() {
        LogIt.log("===== SEARCHING FOR PRINTER =====");
    }

    private void logFindPorts() {
        LogIt.log("===== SEARCHING FOR SERIAL PORTS =====");
    }

    private void logOpeningPort() {
        LogIt.log("===== OPENING SERIAL PORT " + this.serialPortName + " =====");
    }

    private void logClosingPort() {
        LogIt.log("===== CLOSING SERIAL PORT " + this.serialPortName + " =====");
    }

    private void logCommands(PrintHTML ph) {
        this.logCommands(ph.get());
    }

    private void logCommands(PrintRaw pr) {
        this.logCommands(pr.getOutput());
    }

    private void logCommands(byte[] commands) {
        try {
            this.logCommands(new String(commands, this.charset.name()));
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.WARNING, "Cannot decode raw bytes for debug output. This could be due to incompatible charset for this JVM or mixed charsets within one byte stream.  Ignore this message if printing seems fine.");
        }
    }

    private void logCommands(String commands) {
        LogIt.log("\r\n\r\n" + commands + "\r\n\r\n");
    }

    private void logAndPrint(PrintRaw pr, byte[] data) throws IOException, InterruptedException, PrintException, UnsupportedEncodingException {
        this.logCommands(data);
        pr.print(data);
    }

    private void logAndPrint(PrintRaw pr) throws IOException, PrintException, InterruptedException, UnsupportedEncodingException {
        this.logCommands(pr);
        if (this.reprint) {
            pr.print();
        } else {
            pr.print();
            pr.clear();
        }
    }

    private void logAndPrint(PrintPostScript printPS) throws PrinterException {
        this.logCommands("    <<" + this.file + ">>");
        printPS.print();
        this.psPrint = false;
    }

    private void logAndPrint(PrintHTML printHTML) throws PrinterException {
        if (this.file != null) {
            this.logCommands("    <<" + this.file + ">>");
        }
        this.logCommands(printHTML);
        printHTML.print();
        this.htmlPrint = false;
    }

    public void setEncoding(String charset) {
        System.out.println("Default charset encoding: " + Charset.defaultCharset().name());
        try {
            this.charset = Charset.forName(charset);
            this.getPrintRaw().setCharset(Charset.forName(charset));
            LogIt.log("Current applet charset encoding: " + this.charset.name());
        }
        catch (IllegalCharsetNameException e) {
            LogIt.log(Level.WARNING, "Could not find specified charset encoding: " + charset + ". Using default.", e);
        }
    }

    public String getEncoding() {
        return this.charset.displayName();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setOrientation(String orientation) {
        if (this.paperSize == null) {
            LogIt.log(Level.WARNING, "A paper size must be specified before setting orientation!");
        } else {
            this.paperSize.setOrientation(orientation);
        }
    }

    public void allowMultipleInstances(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
        LogIt.log("Allow multiple applet instances set to \"" + allowMultiple + "\"");
    }

    public void setAllowMultipleInstances(boolean allowMultiple) {
        this.allowMultipleInstances(allowMultiple);
    }

    public boolean getAllowMultipleInstances() {
        return this.allowMultiple;
    }

    public void setAutoSize(boolean autoSize) {
        if (this.paperSize == null) {
            LogIt.log(Level.WARNING, "A paper size must be specified before setting auto-size!");
        } else {
            this.paperSize.setAutoSize(autoSize);
        }
    }

    public Integer getCopies() {
        return this.copies;
    }

    public void setCopies(int copies) {
        this.copies = copies;
    }

    public PaperFormat getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(String width, String height) {
        this.paperSize = PaperFormat.parseSize(width, height);
        LogIt.log(Level.INFO, "Set paper size to " + this.paperSize.getWidth() + this.paperSize.getUnitDescription() + "x" + this.paperSize.getHeight() + this.paperSize.getUnitDescription());
    }

    public void setPaperSize(float width, float height) {
        this.paperSize = new PaperFormat(width, height);
        LogIt.log(Level.INFO, "Set paper size to " + this.paperSize.getWidth() + this.paperSize.getUnitDescription() + "x" + this.paperSize.getHeight() + this.paperSize.getUnitDescription());
    }

    public void setPaperSize(float width, float height, String units) {
        this.paperSize = PaperFormat.parseSize("" + width, "" + height, units);
        LogIt.log(Level.INFO, "Set paper size to " + this.paperSize.getWidth() + this.paperSize.getUnitDescription() + "x" + this.paperSize.getHeight() + this.paperSize.getUnitDescription());
    }
}

