/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jzebra.PrintApplet;

public class PrintHTML
extends JLabel
implements Printable {
    private final AtomicReference<PrintService> ps = new AtomicReference<Object>(null);
    private final AtomicReference<String> jobName = new AtomicReference<String>("jZebra 2D Printing");
    private final AtomicInteger orientation = new AtomicInteger(1);
    private final AtomicReference<String> htmlData = new AtomicReference<Object>(null);

    public PrintHTML() {
        super.setOpaque(true);
        super.setBackground(Color.WHITE);
    }

    public void append(String html) {
        this.htmlData.set(this.htmlData.get() == null ? html : this.htmlData.get() + html);
    }

    public void clear() {
        this.htmlData.set(null);
    }

    public String get() {
        return this.htmlData.get();
    }

    private String[] getHTMLDataArray() {
        return this.htmlData.get().split("(?i)</html>");
    }

    public void print() throws PrinterException {
        JFrame j = new JFrame(this.jobName.get());
        j.setUndecorated(true);
        j.setLayout(new FlowLayout());
        this.setBorder(null);
        for (String s : this.getHTMLDataArray()) {
            this.setText(s + "</html>");
            j.add(this);
            j.pack();
            j.setExtendedState(1);
            j.setVisible(true);
            HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
            attr.add(new MediaPrintableArea(0.0f, 0.0f, (float)this.getWidth() / 72.0f, (float)this.getHeight() / 72.0f, 25400));
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(this.ps.get());
            job.setPrintable(this);
            job.setJobName(this.jobName.get());
            job.print(attr);
            j.setVisible(false);
        }
        j.dispose();
        this.clear();
    }

    public void setPrintParameters(PrintApplet a) {
        this.ps.set(a.getPrintService());
        this.jobName.set(a.getJobName().replace(" ___ ", " HTML "));
    }

    public void setPrintService(PrintService ps) {
        this.ps.set(ps);
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        if (g == null) {
            throw new PrinterException("No graphics specified");
        }
        if (pf == null) {
            throw new PrinterException("No page format specified");
        }
        if (pageIndex > 0) {
            return 1;
        }
        boolean doubleBuffered = super.isDoubleBuffered();
        super.setDoubleBuffered(false);
        pf.setOrientation(this.orientation.get());
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        this.paint(g2d);
        super.setDoubleBuffered(doubleBuffered);
        return 0;
    }
}

